<?php

/*
 * Example PHP implementation used for the index.html example
 */

// DataTables PHP library
include( "../php/DataTables.php" );

// Alias Editor classes so they are easy to use
use
	DataTables\Editor,
	DataTables\Editor\Field,
	DataTables\Editor\Format,
	DataTables\Editor\Mjoin,
	DataTables\Editor\Options,
	DataTables\Editor\Upload,
	DataTables\Editor\Validate,
	DataTables\Editor\ValidateOptions;
Editor::inst( $db, 'products_description', 'products_id' )
    ->field(
        Field::inst( 'products_description.products_id' ),
        Field::inst( 'products_description.products_name' ),
        Field::inst( 'products_description.products_description' ),
        Field::inst( 'products.products_model' )
			->getFormatter( Format::dateSqlToFormat('Y-m-d H:i' ) ),
        Field::inst( 'products.products_status' )
			->setFormatter( function ( $val, $data, $opts ) {
                return ! $val ? 0 : 1;
			} )
    )
    ->leftJoin( 'products', 'products.products_id', '=', 'products_description.products_id' )
    ->process($_POST)
    ->json();